	% Box 14.7
	clear all, close all
	clc
	
	M = 5; wcT = 0.1*pi;   dc = 0.01; ds = 0.001; 
	wcT = 0.1*pi;	% Passband
	wsT1 = [(2*pi/M - wcT) (2*pi/M + wcT)];	% Stopband edges
	wsT2 = [(2*pi*2/M - wcT) (2*pi*2/M + wcT)];
	wT_edge = [0 wcT wsT1 wsT2];
	[h, Err] = REMEZ_FIR(26, wT_edge, [1,1,0,0,0,0], [1 10 10],'m');
	Err	
	wT = linspace(0,pi,2000);
	H = freqz(h,1,wT);
	subplot(2,1,1)
	PLOT_MAG_Z_dB(wT, H, pi, 80,'H')
	subplot(2,1,2) 
	wT = linspace(0,0.2*pi,1000);
	for k = 1:4
		H = freqz(h,1,wT-2*pi*k/M);	
		PLOT_MAG_Z_dB(wT, H, 0.2*pi, 80, 'Aliasing')
		hold on 
	end 
	grid on, zoom on
		
